class Tower_RingOfFire extends Tower;

#exec obj load file=..\Textures\DecayedS.utx package=DecayedS
#exec obj load file=..\Textures\Starship.utx package=Starship
#exec obj load file=..\Textures\FireEng.utx package=FireEng
#exec obj load file=..\Textures\Indus3.utx package=Indus3

#exec mesh import mesh=RingOfFire anivfile=Models\RingOfFire_a.3d datafile=Models\RingOfFire_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=RingOfFire x=0 y=0 z=0
#exec mesh sequence mesh=RingOfFire seq=All startframe=0 numframes=1

#exec meshmap new meshmap=RingOfFire mesh=RingOfFire
#exec meshmap scale meshmap=RingOfFire x=0.13281 y=0.13281 z=0.26563

#exec AUDIO IMPORT FILE="Sounds\SnakeFire.WAV" NAME="SnakeFire" GROUP="RingOfFire"

var Pawn Target;

function PostBeginPlay()
{
	Super.PostBeginPlay();
}

simulated function Tick(float DT) 
{
	if ( Health > 0 )
		{
		Enemy = None;
		OldEnemy = None;
		MyTarget = None;
		AttitudeToPlayer = ATTITUDE_Ignore;
		SetPhysics(PHYS_Flying);
		if (!IsInState('TacticalMove'))
			GotoState('TacticalMove');
		}
	if ( !bRunOnce )
		{
		SetTimer(TimerSpeed[TowerLevel],True);
		bRunOnce = True;
		}
}

state TacticalMove
{
ignores SeePlayer, HearNoise;

function FireAtEnemy()
	{
	local Pawn P;
	local bool bBalloonWithinRange;
	local float Range;
	local PBPRI PRI;

	PRI = PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo);
	
	//if ( PRI.KrallLevel == 0 )
	Range = 300;
	
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		{
		if ( P.IsA('Balloon') )
			{
			if ( Vsize(P.Location - Location) < Range )
				{
				bBalloonWithinRange = True;
				}
			}
		}
	if ( bBalloonWithinRange )
		FlameBurst();
	}
	
function FlameBurst()
	{
	local Vector AimDir, ProjStart;
	local Projectile p;
	local Rotator FireRotation;
	local int i, NumBalls;
	local float Spread;
	
	PlaySound(FireSound, SLOT_None,5.0);

	//ProjStart = Location + Vect(0,0,10);
	ProjStart = Location;
	//set NumBalls according to towers level:
	if ( PBPRI(TowerOwner.PlayerReplicationInfo).RingOfFireLevel == 1 )
		NumBalls = 12;
	else if ( PBPRI(TowerOwner.PlayerReplicationInfo).RingOfFireLevel == 2 )
		NumBalls = 18;
	else if ( PBPRI(TowerOwner.PlayerReplicationInfo).RingOfFireLevel == 3 )
		NumBalls = 24;
	else
		NumBalls = 8;
	Spread = 65536 / Numballs; //16384,32768,65536
	//AimDir = Location * CollisionRadius - Location;
	AimDir = Location + Vect(1,1,10);
	for (i=1;i<NumBalls+1;i++)
		{
		FireRotation = rotator(AimDir) * i * Spread;
		FireRotation.Pitch = 0;
		FireRotation.Roll  = 0;
		p = Spawn (ProjectileType,TowerOwner,,ProjStart,FireRotation);
		p.DrawScale *= ( 1 + PBPRI(TowerOwner.PlayerReplicationInfo).RingOfFireLevel );
		p.instigator = TowerOwner;
		}
	}
}

defaultproperties
{
	 TowerName="Ring of fire Tower"
	 ProjectileType=Class'Proj_Tower_RingOfFire'
	 FireSound=Sound'SnakeFire'
	 TimerSpeed(1)=1.5
	 TimerSpeed(2)=1.4
	 TimerSpeed(3)=1.3
	 TimerSpeed(4)=1.2
     DrawType=DT_Mesh
     Mesh=Mesh'RingOfFire'
     TransientSoundVolume=1.500000
     CollisionRadius=24.00000
	 CollisionHeight=34.00000
     Mass=140.000000
     Buoyancy=140.000000
	 DrawScale=0.5
	 MultiSkins(0)=Texture'DecayedS.Wall.WALL3d'
	 MultiSkins(1)=Texture'Starship.Base.basic2a'
	 MultiSkins(2)=Texture'FireEng.Fire1'
	 MultiSkins(3)=Texture'Indus3.CeilingPipe'
}
